#define	LARGE	16000
#define	HUGE	32000
/*	spell the word beginning with a given string */

struct filpos {
	int block;
	int ch;
};

/* buffer structure for getc -*/
struct {
	int fildes;
	int nleft;
	char *nextp;
	char buffer[512];
} getbuf;
char bigbuf[1600];
char *tbuf	&bigbuf[512];

main(argc, argv)
	char **argv;
{
	register char *sp;

	if(argc != 2 || word(*++argv) == 0) {
		puts(1, "[argument error]");
		return;
	}

	if((sp=search("/usr/lib/w2006", *argv)) == 0) {
		puts(1, "[no match]");
		return 0;
	}
}

word(string)
	char *string;
{
	register char *sp;

	sp = string;
	do {
		if(*sp>='A' && *sp<='Z') *sp =+ 'a'-'A';
		if(*sp<'a' || *sp>'z') return 0;
	} while(*++sp);
	return 1;
}

char *search(filename, string)
	char *filename, *string;
{
	register char *sp, *rp, *tp;
	int i,  l, n, fildes;
	char linebuf[128];
	struct filpos	*position;
	struct status {
		int ident[2];
		int flags;
		char nlinks;
		char uid;
		char gid;
		char size0;
		int size;
		int addr[8];
		int acdate[2];
		int date[2];
		}stat;

	if((fildes = open(filename, 0))<0) return 0;
	fstat(fildes, &stat);
	getbuf.fildes = fildes;

	l = (stat.size0<<7) + ((stat.size>>9)&0177);
	if(position = binsplit(fildes, string, 0, l, l)) {
			seek(fildes, position->block, 3);
			read(fildes, getbuf.buffer, 512);
			getbuf.nextp = getbuf.buffer+position->ch;
			getbuf.nleft = 512-position->ch;
			i = 0;
			do {
				sp = linebuf;
				while((*sp++ = getc(&getbuf)) != '\n');
				*sp = '\0';
				if(compare(string, linebuf) == 0)
					putb(1, linebuf);
				else break;
			} while(++i);
			if(i == 0) puts(1, "[no matching words]");
		return position;
	}
	return 0;

/* should check each line for match */
}

int binsplit(fildes, string, fblock, lblock, endblock)
	char *string;
/*
	finds the first ocurrence of a line commencing with
	string in the ordered file fildes between first and last.
	the file pointer is left at the first.
*/
{
	int n, split, found;
	char *sp;
	static struct filpos	position;
	static int oldsplit;

	split = fblock + ((lblock-fblock)>>1); /* ie divided by two */
	if(split == oldsplit) return 0;
	oldsplit = split;
	seek(fildes, split, 3);
	n = read(fildes, tbuf, 512);
	tbuf[n] = '\0';
	found = contline(tbuf, n, string);
	if(found == -1) {	/* on the boundary */
		if(split) {
			split--;
			seek(fildes, split, 3);
			read(fildes, tbuf-512, 512);
			found = contline(tbuf-512, n+512, string);
			if(found < 0) if(fblock) fblock--;
		} else found = 0;
	}
	if(found < 0)
		return binsplit(fildes, string, fblock, split, endblock);
	if(found == 512) { /* it may be on the break */
		if(split<endblock) {
			n =+  read(fildes, tbuf+512, 512);
			tbuf[n] = '\0';
			found = contline(tbuf, n, string);
			if(found >= 512) {
				found = HUGE;
				if(lblock<endblock) lblock++;
			}
			else seek(fildes, split+1, 3);
		} else {
			sp = tbuf+512;
			while(*--sp != '\n');
			found = sp-tbuf+1;
		}
	}
	if(found > LARGE)
		return binsplit(fildes, string, split+1, lblock, endblock);

	split =+ found/512;
	found = found%512;
	position.block = split;
	position.ch = found;
	return &position;	/* to indicate success */
}

int contline(buf, n, string)
	char *buf, *string;
{
	register char *rp, *sp, *tp;
	char *xp;
	int rel;
/* maybe should use binary splitting within the block */

	rp = buf;
	while(*rp++ != '\n');
	if((rel = compare(string, rp))<0) return -HUGE;
	if(rel == 0){
		sp = string;
		tp = rp;
		while(*sp++ == *tp++);
		if(*--tp == '\n')  return rp-buf;
		return -1;
	}
	tp = buf+n;
	while(*--tp != '\n') if(tp<buf) return HUGE;
	xp = sp = tp+1;
	while(*--tp != '\n') if(tp<buf) return HUGE;
	tp++;
	if(compare(string,tp)>0) {
		if(compare(string, sp) == 0) {
			tp = string;
			do {
				if(*sp == 0 || *tp == 0) break;
			} while(*tp++ == *sp++);
			if(*tp == '\0' && sp == buf+512) return xp-buf;
			return 512;
		}
		else return HUGE;
	}

	do {
		if(compare(string, rp) == 0) return rp-buf;
		while(*rp++ != '\n') if(*rp == '\0') return HUGE;
	}while(*rp != '\0');
	return HUGE;
}

compare(p1, p2)
char *p1, *p2;
{	register char d, *rp1, *rp2;

	if(*(rp1 = p1) == 0) return -HUGE;
	if(*(rp2 = p2) == 0) return -HUGE;

	while((d = *rp1++ - *rp2++) == 0);
	if(*--rp1 == '\0' || *--rp2 == '\0') return 0;
	return d;
}

puts(filedes, as)	char *as;
{	putb( filedes, as); putch( filedes, '\n'); }

putch(filedes, ch) char ch;
{ write(filedes, &ch, 1); }

putb(filedes, ptr)	char *ptr;
{	register char *p;

	p = ptr;
	if(*p == '\0') return;
	while(*(++p));
	write( filedes,ptr,p-ptr);
}

