#
/*
	send

function:
	A message sending program modeled after the tenex program
	sndmsg.

parameters:
	Optional, a list of recipients


returns:
	It delivers local mail by appending it to a file called .mail
	in the user's root.
	If the transmission fails, a copy is left in the author's
	 root as unsent.mail

history:
	Originally written by someone at Berkeley (Murray Bowles?)
	Reorganized and augmented by Mark Kampe 10/75
	Re-hacked by George Coulouris Sept. 76 to use editor as message
	editing facility. Omitting network stuff
*/

#define loop for(;;)
#define true 1
#define false 0
#define	SIGINTR	2
#define USRBRK 02000
#define MSGSEP  "\001\001\n"	/* message separator */
#define SCOPE  0400
#define	SPACE	040
#define SMALLBUFLEN 256

#define LOCAL	" at QMC CS Lab"
#define MAILFILE	"/.mail"
#define	NOTIFICATION "\r\n\t\007*** [YOU HAVE NEW MAIL] ***\r\n"
#define del 0177
#define abortchar 034
#define disable old_signal = signal(2,1)
#define enable signal(2,old_signal)
#define then /**/


struct status
	{
	char	s_minor;
	char	s_major;
	int	s_number;
	int	s_mode;
	char	s_nlinks;
	char	s_uid;
	char	s_gid;
	char	s_size0;
	int	s_size1;
	int	s_addr[8];
	int	s_actime[2];
	int	s_modtime[2];
	} statb;

int pwfd;
int tmpfd;
int fd;
int namefd;
int mbfd;
char bigbuf[512];
char pwbuf[512];
char *pwptr;
int pwcount;
int netmsgs;
char cc[2*SMALLBUFLEN],to[SMALLBUFLEN],subject[SMALLBUFLEN];
char user[40];
char answer[10];
char dbuf[32];
char authorfile[64],mailbox[64],from[64],netfile[64];
char	lettmp[] "/tmp/maxxxxx";
char	preptmp[] "/tmp/mbxxxxx";
char	inbuf[512];
int	incount;
char	*inptr;
char hostname[64];
char *letter,*date;
struct {
	int	t_speeds;
	char	t_erase;
	char	t_kill;
	int	t_flags;
	char	t_nldelay;
	char	t_crdelay;
	char	t_tbdelay;
	char	t_vtdelay;
	char	t_width;
	char	t_length;
	int	t_brktab[2];
	} ttys;
int oldmode,uid,gid,old_signal,myuid;
int unsent false;
int file false;
int oldfile false;


main(argc,argv)
char *argv[];
int argc;
{
	register char *p;
	register char *s;
	register int i;
	int vector[2];
	incount = 0;

	if ((pwfd = open("/etc/passwd",0)) < 0)
		{
		printf("Couldn't open password file!\n");
		delexit();
		}
	getname(from);
	time(vector);
	date = arpadate(vector);
	p = to;
	for(i = 1; i < argc; i++)
	{	for(s = argv[i]; *s; *p++ = *s++);
		*p++ = ',';
	}
	if (p == to) then
	{	printf("To: ");
		gather(to);
	}
	else	*--p = '\000';
	if (*to == '\000') { printf("No destination?\n"); delexit(); }
	printf("Copies to: "); p = gather(cc);
	printf("Subject: "); gather(subject);
	signal(SIGINTR, delexit);
	input();
	printf("Additional recipients: ");
	if (p == cc)
		gather(cc);
	else
	{	*p++ = ',';
		gather(p);
	}
	send(to);
	send(cc);
	
	
	if (netmsgs)
	{	printf("Send network mail now? ");
		gather(answer);
		if (answer[0] != 'y') delexit();
		else	execl("/usr/bin/mailer", "mailer", 0);
	}
	if(unsent)  {
		if(prepend(authorfile))
			printf("A copy of this message is in %s\n", authorfile);
	}
	close(tmpfd);
	delexit();
}


gather(sp)
char *sp;
{
register char c;
register char *p;

p = sp;
while((c = getchar(0)) != '\n' && c>0)
{	if (c == '\\') 	{
		if((*p++ = slashc()) == '\n') *p++ = '\t';
	}
	else *p++ = c;
	if ((p - sp) >= SMALLBUFLEN) break;
}
*p = '\0';
return( p );
}


writef(afd,str)
int afd;
char *str;
{	register int count;
	register char *s;

	s = str;
	for(count=0; *s++; count++);

	return(write(afd,str,count));
}

input()
{
char *tp;
register char *p,c;
register int i;
int scopemode;
char filename[50];

/* Change for new console handler, is a gtty for old one */
/* q:should check ttymode here and set scopemode (i.e. has backspace) */
	scopemode = false;
/* and I don't know what you should do about the scopemode bit */

	maketemp();
	tmpfile(authorfile);	/* get a filename */
	if ((tmpfd = creat(lettmp,0600)) < 0)
	{	printf("Unable to create %s\n", lettmp);
		delexit();
	}
	chown(lettmp, uid);
	writef(tmpfd, MSGSEP);
	writef(tmpfd,"From: ");
	writef(tmpfd, from);
	writef(tmpfd, LOCAL);
	p = subject;
	if (*p)	writef(tmpfd,"\nSubject: ");
	writef(tmpfd, subject);
	writef(tmpfd,"\nTo: ");
	p = to;
	while(*p)
	{	if (*p != '@')
			write(tmpfd, p, 1);
		else	writef(tmpfd, " at ");
		if (*p++ == '\n') writef(tmpfd,"to: ");
	}
	p = cc;
	if (*p)	writef(tmpfd,"\nCopies to: ");
	while(*p)
	{	if (*p != '@')
			write(tmpfd, p, 1);
		else	writef(tmpfd, " at ");
		if (*p++ == '\n') writef(tmpfd,"Copies to: ");
	}
	writef(tmpfd,"\nDate: ");
	writef(tmpfd,date);
	writef(tmpfd,"\n-------\n\n");
	close(tmpfd);

/* q: here we fork to the editor in 'elfic' mode to generate the
message. */
	printf("\nMessage: (use editor commands, 'q' when message completed)\n");
	editor(lettmp);

	/* whole message is now in temp file */
	/* close it and reopen it for input */
	if((tmpfd = open(lettmp,2))<0) {
		printf("message not created\n");
		 delexit();
	}
	seek(tmpfd, 0, 2);	/* seek to end */
	writef(tmpfd, MSGSEP);
} /* end of input */

editor(filename)
char *filename;
{
	register savint, pid, rpid;
	int retcode;

	if((pid = fork()) == 0) {
		execl("/bin/em", "em", "-e", filename, 0);
	}
	/* wait for editor to do the dirty work of making the message */
	savint = signal(SIGINTR, 1);
	while((rpid = wait(&retcode)) != -1);
	signal(SIGINTR, savint);

}

send(list)
char *list;
{
register char *name,*curp;
register char c;

curp = list;
while (file || *curp)
{	name = user;
	while (valid(c = file?getchar(namefd):*curp++))
		*name++ = c;
	*name = '\0';
	switch (c)
		{
case ':':	if (file)
			printf("Nested name files not allowed.\n");
		else
			{
			if ((namefd = open(user,0)) < 0)
				{
				printf("Couldn't open %s\n",user);
				unsent++;
				continue;
				}
			else
				{
				file++;
				continue;
				}
			}

case -1:	close(namefd);
		file = false;
		continue;
case ',':
case ' ':
case '\n':
case '\0':
		if (*user == '\000') continue;
		printf("%s...",user);
		if (network(user))
		{	printf("sorry, ARPAnet not available\n");
			unsent++;
			continue;
		}
		else if (findlocal(user))
		{	stcat(MAILFILE,mailbox);
			post();
			continue;
		}
		else
		{	printf("Not a known user\n");
			unsent++;
			continue;
		}

default:	printf("Illegal terminator %c.\n",c);
		printf("User name %s ignored.\n",user);
		} /* end switch */
	}
} /* end send */

findlocal(name)
char *name;
{
register char *np;
register char pwc;

/*	rewind the password file */
seek(pwfd,0,0);
pwcount = 0;

pwc = 1;
while(pwc > 0)
{	np = name;	/* search for a line starting with name */
	for(pwc = getpwchar(); pwc == *np++; pwc = getpwchar());
	if ((pwc == ':') && (*--np == '\000')) goto gotuser;
	while( (pwc != '\n') && (pwc > 0) ) pwc = getpwchar();
}
return(false);

gotuser:	/* extract all neat info from pw entry */
for(pwc = getpwchar(); pwc != ':'; pwc = getpwchar());
/* we have skipped over the password */
for(uid = 0; (pwc = getpwchar()) != ':'; uid =+ (9*uid) + pwc - '0');
for(gid = 0; (pwc = getpwchar()) != ':'; gid =+ (9*gid) + pwc - '0');
for(pwc = getpwchar(); pwc != ':'; pwc = getpwchar());
/* we have skipped over the gecos bin */
np = mailbox;
for(pwc = getpwchar(); pwc != ':'; pwc = getpwchar()) *np++ = pwc;
*np = '\000';
return(true);
}


network(name)
char *name;
{	register char *c;
	register char *d;
	register char *e;

	for(c = name; *c; c++) if (*c == '@') goto netname;
	return(false);

netname:
	*c++ = '\000';
	d = hostname;
	for(e = "/dev/net/"; *e;) *d++ = *e++;
	while(*d++ = *c++);
	return(true);
}

tmpfile(ubuf)
char *ubuf;
{
	ubuf[0] = '\000';
	findlocal( from );
	stcat( mailbox, ubuf );
	stcat( "/unsent.mail", ubuf );
	return( ubuf );
}

maketemp()
{
	int i, pid, d;

	pid = getpid();
	for (i=11; i>=7; --i) {
		d = (pid&07) + '0';
		lettmp[i] = d;
		preptmp[i] = d;
		pid =>> 3;
	}
}

post()
{
	if(prepend(mailbox) == 0) {
		printf("Unable to access mailbox\n");
		unsent++;
		return (false);
	}
	chown(mailbox,uid);
	if (notify()) printf("notified\n");
	else printf("ok\n");
	return(true);
} /* end post */


prepend(filename)
	char *filename;
/* prefix the file whose name is given by the message file */
{
	int pfd, n;

	if((pfd = creat(preptmp, 0600))<0) {
		printf("can't create another tempfile - ");
		return 0;
	}
	close(pfd);
	pfd = open(preptmp, 2);
	seek(tmpfd,0,0);	/* rewind the message file */
	while((n = read(tmpfd,bigbuf,512))>0) write(pfd, bigbuf, n);
	if(stat(filename, &statb) < 0) {
		if((mbfd = creat(filename, 0666))<0) {
			printf("can't create %s - ", filename);
			return 0;
		}
	close(mbfd);
	}
	if ((mbfd = open(filename,2))<0) {
		printf("can't open %s - ", filename);
		return 0;
	}
	if (statb.s_nlinks >1) {
		printf("mailbox in use - ");
		return 0;
	}
	while((n = read(mbfd, bigbuf, 512))>0) write(pfd,bigbuf,n);
	seek(mbfd,0,0);		/* rewind mail file */
	seek(pfd,0,0);
	while((n = read(pfd,bigbuf,512))>0) write(mbfd,bigbuf,n);
	close(mbfd);
	close(pfd);
	return 1;
}

notify()
{	char ttylst[8];
	int lfd;
	int noteflag;
	char *utty, self;
	register int count;
	register char *p1;
	register char *p2;
	struct systat
	{	char name[8];
		char ttychar;
		char empty;
		int time[2];
		char null[2];
	} stats;


	utty = "/dev/tty?";
	self = ttyn(0);
	noteflag = false;
	count = 0;
	if ((lfd = open("/etc/utmp",0)) < 0) return(false);
	while (read(lfd,&stats,16))
	{	p1 = user;
		p2 = &stats.name[0];
		while (*p1++ == *p2++);
		if(*(--p1) != '\0' || *(--p2) != SPACE
			|| stats.ttychar == self) continue;
		ttylst[count++] = stats.ttychar;
		if (count > 6) break;
	}
	close(lfd);
	if (!count) return(false);
	ttylst[count] = 0;
	p1 = ttylst;
	while(*p1)
	{	utty[8] = *p1++;
		if (stat(utty,&statb) < 0) continue;
		if (!(statb.s_mode & 02)) continue;
		if ((lfd = open(utty,1)) > 0)
		{	if (writef(lfd, NOTIFICATION) > 0)
				noteflag = true;
			close(lfd);
		}
	}
	if (noteflag) return(true);
	else return(false);
}


/* not used in QMC 'send at present 
netpost(uname,hname)
 char *uname;
 char *hname;
{
	register char *p1;
	register char *p2;
	register int i;

	if (stat(hname,&statb) == -1)
	{	printf("host is unknown\n");
		unsent++;
		return(false);
	}

	p2 = netfile;
	for(p1 = "/usr/netmail/"; *p1; *p2++ = *p1++);
	i = p2;
	for(p1 = from; *p1; *p2++ = *p1++);
	while((p2 - i) < 14) *p2++ = '0';
	*p2-- = '\000';
	for(i = 'a'; i <= 'z'; i++)
	{	*p2 = i;
		if (stat(netfile,&statb) == -1) goto gotname;
	}
	printf("Too many messages awaiting transmission\n");
	unsent++;
	return(false);

gotname:
	mbfd = creat(netfile, 0444);
	if (mbfd < 0)
	{	printf("Unable to create mailfile for %s@%s\n",
			uname,hname);
		unsent++;
		return(false);
	}

	writef(mbfd,hname);
	write (mbfd,":",1);
	writef(mbfd,uname);
	write (mbfd,":",1);
	if (findlocal(from)) writef(mbfd,mailbox);
	write (mbfd, ":\n",2);

	seek(tmpfd, 0, 0);
	for(i = read(tmpfd,bigbuf,512); i; i = read(tmpfd,bigbuf,512))
		write(mbfd,bigbuf,i);

	close(mbfd);
	chown(netfile,myuid);
	printf("Queued for transmission\n");
	netmsgs++;
	return(true);
}

*/

getname(caller)
char *caller;
{
char linebuf[100];
char *cp,*lp;

myuid = getuid() & 0377;
if (getpw(myuid, linebuf))
{
	printf("Your user id is not in the password file?!?\n");
	delexit();
}
cp = caller;
lp = linebuf;
while(*lp != ':') *cp++ = *lp++;
*cp = '\000';
return(caller);
}


slashc()
{
char c;
c = getchar(0);
return(c);
} /* end slashc */



char getchar(cfd)
{	char c;
	register int i;

	if (incount == 0)
	{	incount = read(cfd, inbuf, 512);
		inptr = inbuf;
	}
	if (incount <= 0) return(-1);
	incount--;
	return((*inptr++)&0177);
}
char getpwchar()
{
tryagain:
	if (pwcount > 0)
	{	pwcount--;
		return(*pwptr++);
	}
	else
	{	pwcount = read(pwfd,pwbuf,512);
		if (pwcount <= 0) return(-1);
		pwptr = pwbuf;
		goto tryagain;
	}
}
valid(ch)
char ch;
{
return(((ch >= 'a') && (ch <= 'z')) | ((ch >= '0') && (ch <= '9')) |
	(ch == '.') | (ch == '/') | (ch == '-') | (ch == ';') |
	(ch == '@') | (ch == '(') | (ch == ')') |
	((ch >= 'A') && (ch <= 'Z'))   );
}
stcat(latter,former)
char *latter,*former;
{
register char *fp,*lp;
fp = former;
lp = latter;
while (*fp++);
fp--;
while (*fp++ = *lp++);
}
char *arpadate(tvec)
 int tvec[2];
{	register int *i;
	register char *p;
	register char *t;

	t = ctime(tvec);
	p = dbuf;

	if (t[8] != ' ') *p++ = t[8];
	*p++ = t[9];
	*p++ = ' ';
	*p++ = t[4];
	*p++ = t[5];
	*p++ = t[6];
	*p++ = ' ';
	*p++ = t[20];
	*p++ = t[21];
	*p++ = t[22];
	*p++ = t[23];
	*p++ = ' ';
	if (t[11] != ' ') *p++ = t[11];
	*p++ = t[12];
	*p++ = t[14];
	*p++ = t[15];
	*p++ = '-';
	i = localtime(tvec);
	if (i[8]) { *p++ = 'B'; *p++ = 'S'; }
	else {  *p++ = 'G'; *p++ = 'M'; }
	*p++ = 'T';
	*p++ = '\000';

	return(dbuf);
}
delexit()
{
	unlink(lettmp);
	unlink(preptmp);
	exit();
}

