#
/*	The new Graphics library package for Unix	*/

/*	Specially hacked about for new illus - Mar 21 1977 A.S.

	gmoveto(x,y)		move to (x,y)
	gpointo(x,y)		move to (x,y) & display a point
	glineto(x,y)		draw line to (x,y)
	gdotsto(x,y)		  "  dots  "   "   & display a point
	gline(dx,dy)		draw line by dx,dy
	gdots(dx,dy)		  "  dots  "   "
	gtext(str)		displays line of text @ current position
	gimlac(frame,signal)	general purpose.Act on frame with signal
	gclose()		close all frames open
	gdrag(frame)		drag frame on cursor
	greposition(frame,x,y)	reposition frame @ (x,y)
	gclear()		clear screen
	gpenin(&x,&y)		puts current pen press position into x & y,
				returns:	ESC if valid point
						-1  if invalid point
						a character if one is typed
*/

#define DELETE		040
#define REPLACE		041
#define OPEN		042
#define CLEARSCREEN	043
#define REPOSFRAME	044
#define DRAG		045
#define UNDRAG		047
#define INVISIBLE	050
#define VISIBLE		051
#define UNFLASH		052
#define FLASH		053

#define FRMS		94
#define NOTDOT		0
#define DOT		02000
#define INVIS		0
#define VIS		02000
#define ABSOLUTE	04000
#define MAG		01777
#define NEG		02000
#define GRAPHCODE	034
#define GESCODE		040
#define ESC		033
#define NOT		~
#define ITT		0100000
#define ECHO		010


char stopcode 036,textcode 0102;
char grafbuf[3] { GRAPHCODE,GESCODE,0 };

gmoveto(x,y)
       {
	 dabs(INVIS,x,y,NOTDOT);
	}

gpointo(x,y)
       {
	 dabs(INVIS,x,y,DOT);
	}

glineto(x,y)
       {
	 dabs(VIS,x,y,NOTDOT);
	}

gdotsto(x,y)
       {
	 dabs(VIS,x,y,DOT);
	}

gline(x,y)
       {
	 drel(x,y,NOTDOT);
	}

gdots(x,y)
       {
	 drel(x,y,DOT);
	}

dabs(vis,xc,yc,intensify)
       {
	 if (xc <0 || xc > 1023)
		return;
	 if (yc <0 || yc > 1023)
		return;
	 sendxy(xc+vis,yc+intensify+ABSOLUTE);
	}

drel(xi,yi,line_type)
       {
	 if (xi > 1023 || xi < -1023)
		return;
	 if (yi > 1023 || yi < -1023)
		return;
	 if(line_type)
		write(1,&stopcode,1);
	 sendxy(signmag(xi),signmag(yi));
	}

gtext(str)
       char *str;
       {
	 write(1,&textcode,1);
	 while (*str != 0)
		write(1,str++,1);
	 write(1,&stopcode,1);
	}

gdrag(fr)
       {
	 if((fr <0) || (fr>FRMS))
		return;
	 grafbuf[1] = GESCODE + fr;
	 grafbuf[2] = DRAG;
	 longwrite(grafbuf,3);
	}

signmag(num)
       {
	 return (num > 0 ? num & MAG : (-num & MAG) | NEG);
	}

sendxy(x,y)
       {
	 char xybuf[4];
	 xybuf[0] = (x >> 6)+GESCODE;	xybuf[1] = (x & 077)+GESCODE;
	 xybuf[2] = (y >> 6)+GESCODE;	xybuf[3] = (y & 077)+GESCODE;
	 longwrite(xybuf,4);
	}

gimlac(fr,sig)
       {
	 if(fr < 1 || fr > FRMS)
		return(0);
	 grafbuf[1] = GESCODE + fr;
	 grafbuf[2] = sig;
	 longwrite(grafbuf,3);
	 return(1);
	}

gclose()
       {
	 write(1,grafbuf,1);
	}

greposition(fr,x,y)
       {
	 if(gimlac(fr,REPOSFRAME))
		sendxy(x,y+ABSOLUTE);
	}

gclear()
       {
	 grafbuf[1] = GESCODE;
	 grafbuf[2] = CLEARSCREEN;
	 longwrite(grafbuf,3);
	}

gpenin(x,y)
       int *x,*y;
       {
	 char data[5];
	 register i;
	 while (read(0,data,1) <= 0);
	 if(*data != '#')
		return(*data);
	 for (i=0;i<5;i++)
		while(read(0,&data[i],1) <= 0);
	 if (data[4] != ESC )
	       {
		 while(data[4] != ESC)
		       {
			 while (read(0,&data[4],1) <= 0);
			 write(1,&data[4],1);
			}
		 print(" bad position received\n\r");
		 return(-1);
		}
	 *x = ((data[0]-GESCODE)<<5) + (data[1]-GESCODE);
	 *y = ((data[2]-GESCODE)<<5) + (data[3]-GESCODE);
	 return(ESC);
	}

/* This routine exists to deal with communication difficulties
   at 9600 baud
*/

longwrite(buffer,chars)
       {
	 register i;
	 for(i=0 ; i<chars ; i++)
		 write(1,buffer+i,1);
	}

/* This comment contains a page throw...->*/
/*	New illus, 3rd year project 18 Feb 1977  A.Shapiro

   Spec. A general purpose interactive graphical illustrator.
   Design. Program uses doubly linked vector structures with
	   sequential header nodes (frames).
   Use.	All picture drawing can be accomplished using the mouse & menu.
	All file handling & text,using the keyboard.
   Special Feature. Incorporates a call to the shell with picture
		    recovery on return.
*/

#define MAXNO		32767
#define NL		012
#define USRBRK		02000
#define	BAD		-1
#define END		-100
#define	FRAMES		93
#define	VECTORS		1000
#define OFF		0
#define ON		1
#define INSTR		1
#define GFRAME		94
#define TEXTFRAME	93
#define MENU		2
#define TITLEWIDTH	10
#define CHARHEIGHT	20
#define CHARWIDTH	14
#define CHARS		73
#define MOVE		1
#define DOTS		2
#define LINE		3
#define CHAR		4
#define DRGM	0
#define SHELL	1
#define CLEAR	2
#define DLTM	3
#define RMLN	4
#define DLPC	5
#define CPPC	6
#define NPIC	7
#define GFRC	8
#define FLSH	9
#define MERGE	10
#define SAVE	11
#define TEXT	12
#define REST	13
#define CONTL	14
#define CONTD	15
#define DRAWL	16
#define DRAWD	17
#define MENULENGTH	17
#define GSTAT	20
#define GDEF	40
int Gstore		10;
int  pre_x,pre_y,x,y,dots,press,frame,G_force,svflg;
char menudisplayed,clearflag,flash,Gdisp;
char continuous,firstime,dragflag,fileflag,pics;
char fstring[CHARS+14];

/* Structure for frame storage
	in_use can take values:
		0...frame not used
		>0 = address of first vector in chain
		<0 = -address of first vector in chain
		     this indicates frame needs redrawing on
		     screen as vector storage no longer corresponds
		     to picture displayed.
	xpos & ypos are the first point displayed (this implies a
		moveto).
	xdif & ydif are the dx & dy  through which this frame has
		been dragged since the last redraw.
	lastvec contains the address of the last vector in chain.
*/

struct framesdef
       {
	 int in_use;
	 int xpos;
	 int ypos;
	 int xdif;
	 int ydif;
	 int lastvec;
	}		frames[FRAMES],*fptr;

/* Structure for vector storage
	mode can take values:
		0...node not used
		1...point specified is a moveto
		2...  "     "	"    " " lineto
		3...  "     "	"    " " dotsto
		4...x_pos & y_pos contain 4 chars.
	x_pos & y_pos contain data for mode.
	nextvec can take values:
		>0 = address of next vector in chain
		<0 = -frame number
		     this means there are no more vectors in chain.
	prevec can take values:
		>0 = address of previous vector in chain
		<0 = -frame number
		     means that this is the first vector in chain.
*/

struct vectordef
       {
	 int mode;
	 int x_pos;
	 int y_pos;
	 int nextvec;
	 int prevec;
	}		vector[VECTORS],*vptr,*avail;
struct terdef
       {
	 char inspeed;
	 char outspeed;
	 char erase;
	 char kill;
	 int  flags;
	 char nldelay;
	 char crdelay;
	 char tbdelay;
	 char vtdelay;
	 char width;
	 char length;
	 int  brks[8];
	}		ter,oldter;

/* Structure for file i/o.
*/

struct buftag
       {
	 int fildes;
	 int nleft;
	 char *nextp;
	 char bufer[512];
	}		buffer;

/* The main segment. After setting up the terminal modes and special
   treatment of ^c,the program initialises all the dynamic variables
   & sits in the command loop (The last reseter is redundant but has
   been included as a safety net).
*/

main()
       {
	 int (reseter)();
	 seter();
	 signal(2,reseter);
	 G_force = Gstore;
	 initialise();
	 frames[0].xpos = 800;
	 frames[0].ypos = 900;
	 instr(17);
	 menu();
	 while(command());
	 reseter();
	}

/* This routine initialises all the dynamic variables,except
   Gstore, Gdisp & menu position, which carry through.
*/

initialise()
       {
	 register i;
	 register struct vectordef *ivptr;
	 register struct framesdef *ifptr;
	 ivptr=avail=vector;
	 ifptr = &frames[2];
	 menudisplayed=pics = fileflag = OFF;
	 flash = dragflag = continuous = OFF;
	 for(i=0 ; i<VECTORS-1 ; i++,ivptr++)
	       {
		 ivptr->mode = 0;
		 ivptr->prevec = -1;
		 ivptr->nextvec = ivptr+1;
		 ivptr->x_pos = ivptr->y_pos = 0;
		}
	 ivptr->mode = 0;
	 ivptr->prevec = -1;
	 ivptr->nextvec = END;
	 for(i=3 ; i<FRAMES ; i++,ifptr++)
	       {
		 ifptr->in_use = 0;
		 ifptr->xpos = ifptr->ypos = 0;
		 ifptr->xdif = ifptr->ydif = 0;
		 ifptr->lastvec = 0;
		}
	 gclear();
	 next_frame(OFF);
	}

/* This routine sets up terminal modes & saves the entry modes
   for reinstatement on exit.Modes are:
			length & width  0
			userbreak on escape
			not echo
			not itt.
*/

seter()
       {
	 register i;
	 gterm(0,&ter);
	 gterm(0,&oldter);
	 for(i=0 ; i<8 ; i++)
		 ter.brks[i] = 0;
	 ter.flags =| USRBRK;
	 ter.flags =& NOT ECHO;
	 ter.flags =& NOT ITT;
	 setbit(ter.brks,ESC);
	 ter.width = ter.length = 0;
	 sterm(0,&ter);
	}

/* This routine sets up original length & width userbreak
   on new line & echo, for typing in characters.
*/

charter(cspec)
       {
	 if(cspec)
	       {
		 ter.width = oldter.width;
		 ter.length=oldter.length;
		}
	 ter.brks[1] = 0;
	 setbit(ter.brks,NL);
	 svflg = ter.flags;
	 ter.flags =| ECHO;
	 sterm(0,&ter);
	}

/* This routine counteracts charter.
*/

uncharter()
       {
	 print("\n\n\n\n\n");
	 ter.width = ter.length = 0;
	 ter.brks[0] = 0;
	 setbit(ter.brks,ESC);
	 ter.flags = svflg;
	 sterm(0,&ter);
	}

/* This routine clears the screen of all but the picture,resets
   the terminal modes to what they were on entry & exits.
*/

reseter()
       {
	 gimlac(INSTR,DELETE);
	 gimlac(MENU,DELETE);
	 gimlac(GFRAME,DELETE);
	 sterm(0,&oldter);
	 exit();
	}

/* This routine finds the next available frame. If nmode is not equal
   to zero it just returns its number,otherwise it sets this frame as
   the current one.
*/

next_frame(nmode)
       {
	 register i;
	 register struct framesdef *nfptr;
	 for(i=3,nfptr = &frames[2] ; i<FRAMES && nfptr->in_use ; i++,nfptr++);
	 if(i >= FRAMES)
	       {
		 print("all segments in use\n");
		 sleep(2);
		 return(-1);
		}
	 if(nmode)
		return(i);
	 frame = i;
	 fptr = nfptr;
	 return(0);
	}

/* This routine outputs screen boundary & helpful!! comments
   according to option.
   To reduce the flash on every press the boundary  could be
   put in its own frame  (cost = 12 words of imlac storage).
*/

instr(option)
       {
	 gimlac(INSTR,REPLACE);
	 gmoveto(0,0);
	 gline(1023,0);gline(0,1023);gline(-939,0);
	 gline(0,-16);gline(-84,0);gline(0,-1009);
	 gmoveto(3,1011);gtext("CANCEL");
	 switch(option)
	       {
		 case 0:
			if(!pics)
			   {
			     gmoveto(200,1000);
			     gtext("To start drawing, use the lower third of the menu");
			    }
			break;
		 case 1:
			gmoveto(325,1000);
			gtext("Press for point");
			break;
		 case 2:
			gmoveto(325,1000);
			dots ? gtext("Press for dots") : gtext("Press for line");
			break;
		 case 3:
			gmoveto(250,1000);
			gtext("Missed...access pictures by their corners");
			break;
		 case 4:
			gmoveto(325,1000);
			gtext("Press picture to screen");
			break;
		 case 5:
			gmoveto(325,1000);
			gtext("Press menu to screen");
			break;
		 case 6:
			gmoveto(325,1000);
			gtext("Repeat press to confirm");
			break;
		 case 7:
			gmoveto(250,1000);
			gtext("Press on picture to be erased");
			break;
		 case 8:
			gmoveto(200,1000);
			gtext("Press on one end of line to be erased");
			break;
		 case 9:
			gmoveto(200,1000);
			gtext("Press on other end of line to be erased");
			break;
		 case 10:
			gmoveto(325,1000);
			gtext("No line found");
			break;
		 case 11:
			gmoveto(250,1000);
			gtext("Press on picture to be copied");
			break;
		 case 12:
			gmoveto(200,1000);
			gtext("Type picture name followed by new line");
			break;
		 case 13:
			gmoveto(250,1000);
			gtext("Press on picture to be saved");
			gmoveto(970,1000);gtext("ALL");
			break;
		 case 14:
			gmoveto(325,1000);
			gtext("Press text to screen");
			break;
		 case 15:
			gmoveto(250,1000);
			gtext("Type in text followed by new line");
			break;
		 case 16:
			gmoveto(250,1000);
			gtext("Press on picture to be merged");
			gmoveto(970,1000);gtext("ALL");
			break;
		 case 17:
			gmoveto(170,1000);
			gtext("Welcome to the illustrator,to quit type a ^c");
			break;
		 case 18:
			gmoveto(170,1000);
			gtext("Unix command level,^d to return to illustrator");
			break;
		 case 19:
			gmoveto(325,1000);
			gtext("Welcome back...^c to quit");
			break;
		 case 20:
			gmoveto(325,1000);
			gtext("New picture requested");
			break;
		 case 21:
			gmoveto(325,1000);
			gtext("No pictures....Yet");
			break;
		 case 22:
			gmoveto(325,1000);
			gtext("Current picture segment empty");
			break;
		 case 23:
			gmoveto(400,1000);
			gtext("Wait");
			break;
		 case 24:
			gmoveto(200,1000);
			gtext("Missed...Next time try a line endpoint");
			break;
		}
	 gclose();
	}

/* This routine draws the main menu.
*/

menu()
       {
	 register mx,my,i;
	 menudisplayed = 1;
	 mx = frames[0].xpos;
	 my = frames[0].ypos;
	 gimlac(MENU,OPEN);
	 gmoveto(mx,my);gtext("Menu");
	 mx =- 25;
	 my =- (CHARHEIGHT+TITLEWIDTH-5);
	 gmoveto(mx,my);gtext("   %");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("del all");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("del menus");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("del lines");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("del picture");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("copy picture");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("new picture");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("proximity");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("flash");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("merge");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("save");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("text");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my);gtext("restore");
	 my =- CHARHEIGHT;
	 gmoveto(mx,my+10);gline(150,0);
	 my =- CHARHEIGHT;
	 gmoveto(mx,my+10);gdots(150,0);
	 my =- CHARHEIGHT;
	 for(i=0 ; i<160 ; i =+ 20)
	       {
		 gmoveto(mx+i,my);gline(0,15);
		}
	 my =- CHARHEIGHT;
	 for(i=0 ; i<160 ; i =+ 20)
	       {
		 gmoveto(mx+i,my);gdots(0,15);
		}
	 gclose();
	}

/* This routine draws the Proximity menu.
*/

Gdisplay()
       {
	 register Gx,Gy;
	 x = frames[0].xpos;
	 y = frames[0].ypos;
	 reposmenu();
	 Gx = x;
	 Gy = y;
	 gimlac(GFRAME,REPLACE);
	 gmoveto(Gx,Gy);
	 Gx =+ 160;
	 gmoveto(Gx,Gy);gtext("Proximity");
	 Gy =- CHARHEIGHT+TITLEWIDTH-5;
	 gmoveto(Gx,Gy);gtext("OFF    ON");
	 if(G_force)
	       {
		 gmoveto(Gx+95,Gy-5);gline(0,21);gline(30,0);
				    gline(0,-21);gline(-30,0);
		}
	   else
	       {
		 gmoveto(Gx-3,Gy-5);gline(0,21);gline(43,0);
				   gline(0,-21);gline(-43,0);
		}
	 Gy =- CHARHEIGHT;
	 gmoveto(Gx,Gy);gtext(" default");
	 Gx =+ 61;
	 Gy = frames[0].ypos-MENULENGTH*CHARHEIGHT;
	 gmoveto(Gx,Gy-9);
	 gline(0,Gstore);
	 gclose();
	}

/* This routine evaluates the last press to see if it falls within the
   bounds of the menu (also detects cancel).If it does it initiates
   the relevant action in a case statement.It returns values in the
   range 1-6 which mean:
		1...normal lowest priority & will not interupt
		    any other mode.
		2...lines requested.This only interupts itself
		    when it would have drawn a line on this press
		3...new picture text etc. requested.This interupts the 
		    same as 2,but causes a different action
		4...not a menu hit,this usually causes a search of
		    the screen to take place to see if the corner of
		    a picture has been hit.
		5...this is returned if a clear has been requested
		    & is responsible for the message
		    "repeat press to confirm"
		6...indicates cancel whatever it is doing & return
		    to wait for further instructions.
*/

evalpress()
       {
	 register ey,eex,eey;
	 int epress,esvflg,gturn;
	 char *esptr,echar,estring[CHARS+1];
	 if(x<84 && y>1009)
	       {
		 instr(0);
		 if(!menudisplayed)
		       {
			 gimlac(MENU,VISIBLE);
			 menudisplayed = ON;
			 if(Gdisp)
				Gdisplay();
			}
		 return(6);
		}
	 if(menudisplayed)
	       {
		 if(x<frames[0].xpos-35 || x>frames[0].xpos+286)
			return(4);
		 ey = (frames[0].ypos-y+TITLEWIDTH)/CHARHEIGHT;
		 if(ey > MENULENGTH)
			return(4);
		 if(x>frames[0].xpos+160)
		       {
			 if(!Gdisp)
				return(4);
			 if(ey>2)
			       {
				 G_force=y-(frames[0].ypos-MENULENGTH*CHARHEIGHT-9);
				 Gstore = G_force;
				 Gdisplay();
				 return(1);
				}
			 ey =* 20;
			}
		 switch(ey)
		       {
			 case SHELL:
				if(dragflag == TEXTFRAME)
					return(1);
				instr(18);
				if((ey = fork()) == 0)
				       {
					 execl("/bin/sh","nshell","-p","nillus: ",0);
					 print("cannot execute shell\n");
					 sleep(2);
					 exit();
					}
				signal(2,1);
				signal(3,1);
				charter(ON);
				while((eex=wait(&epress)) != ey &&
				       eex != -1);
				signal(2,reseter);
				signal(3,0);
				uncharter();
				gclear();
				if(pics)
				     for(eex=3 ; eex < FRAMES ; eex++)
					redraw(eex,ON);
				instr(19);
				menu();
				if(Gdisp)
					Gdisplay();
				 if(dragflag)
					 gdrag(dragflag);
				return(1);
			 case DLTM:
				gimlac(MENU,INVISIBLE);
				if(Gdisp)
					gimlac(GFRAME,DELETE);
				menudisplayed = OFF;
				return(1);
			 case DRGM:
				gdrag(MENU);
				gdrag(GFRAME);
				instr(5);
				x = frames[0].xpos;
				y = frames[0].ypos;
				while((press=gpenin(&x,&y)) != ESC);
				gimlac(MENU,UNDRAG);
				if(Gdisp)
					gimlac(GFRAME,UNDRAG);
				reposmenu();
				return(1);
			 case CONTL:
				if(dragflag)
					return(1);
				dots = OFF;
				continuous=ON;
				firstime = ON;
				return(2);
			 case CONTD:
				if(dragflag)
					return(1);
				dots = ON;
				continuous=ON;
				firstime = ON;
				return(2);
			 case DRAWL:
				if(dragflag)
					return(1);
				dots = OFF;
				continuous = OFF;
				return(2);
			 case DRAWD:
				if(dragflag)
					return(1);
				dots = ON;
				continuous = OFF;
				return(2);
			 case GFRC:
				if(Gdisp)
				       {
					 Gdisp = OFF;
					 gimlac(GFRAME,DELETE);
					 return(1);
					}
				Gdisp = ON;
				Gdisplay();
				return(1);
			 case NPIC:
				if(dragflag)
					return(1);
				instr(20);
				sleep(2);
				instr(0);
				next_frame(OFF);
				if(flash)
				       {
					 gimlac(flash,UNFLASH);
					 flash = OFF;
					}
				return(3);
			 case DLPC:
				if(dragflag || no_pictures())
					return(1);
				gturn = proxon();
				do
				  {
				    instr(7);
				    while((press=gpenin(&x,&y)) != ESC);
				   } while((epress=evalpress()) == 1);
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if((epress=search(END)))
				       {
					 instr(0);
					 frame = epress;
					 fptr = &frames[frame-1];
					 delete(frame);
					}
				   else
				       {
					 instr(3);
					 sleep(2);
					 instr(0);
					}
				if(gturn)
					proxoff();
				return(1);
			 case CPPC:
				if(dragflag || no_pictures())
					return(1);
				gturn = proxon();
				do
				  {
				    instr(11);
				    while((press = gpenin(&x,&y)) != ESC);
				   } while((epress=evalpress()) == 1 || epress == 7);
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if(!(epress=search(END)))
				       {
					 instr(3);
					 sleep(2);
					 if(gturn)
						proxoff();
					 instr(0);
					 return(1);
					}
				if(gturn)
					proxoff();
				frame = epress;
				fptr = &frames[frame-1];
				if(!copy())
				       {
					 instr(0);
					 if(flash)
					       {
						 gimlac(flash,UNFLASH);
						 flash = frame;
						 gimlac(flash,FLASH);
						}
					 return(1);
					}
				instr(23);
				redraw(frame,OFF);
				gdrag(frame,DRAG);
				dragflag = frame;
				do
				  {
				    instr(4);
				    while((press=gpenin(&x,&y)) != ESC);
				   } while((epress = evalpress()) < 4);
				dragflag = OFF;
				gdrag(0);
				instr(0);
				if(epress == 4)
				       {
					 search(frame);
					 reposition();
					 return(7);
					}
				if(epress == 6)
					delete(frame);
				return(epress);
			 case CLEAR:
				if(no_pictures())
					return(1);
				if(!clearflag)
				       {
					 clearflag++;
					 instr(6);
					 while((press=gpenin(&x,&y)) != ESC);
					 if((epress=evalpress()) == 5)
					       {
						 initialise();
						 menu();
						 if(Gdisp)
							Gdisplay();
						 x = frames[0].xpos;
						 y = frames[0].ypos;
						}
					 instr(0);
					 clearflag = OFF;
					 return(epress);
					}
				return(5);
			 case GSTAT:
				if(x>frames[0].xpos+223)
				       {
					 if(G_force)
						return(1);
					 G_force = Gstore;
					 Gdisplay();
					 return(1);
					}
				if(!G_force)
					return(1);
				G_force = OFF;
				Gdisplay();
				return(1);
			 case RMLN:
			     if(dragflag || no_pictures())
				return(1);
			     gturn = proxon();
			     for(;;)
			     {
			      for(;; sleep(2))
			       {
				do
				  {
				    instr(8);
				    while((press=gpenin(&x,&y)) != ESC);
				   } while((epress=evalpress()) == 1);
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if(search())
					break;
				instr(24);
			       }
			      eex = x;
			      eey = y;
			      for(;; sleep(2))
			       {
				do
				  {
				    instr(9);
				    while((press=gpenin(&x,&y)) != ESC);
				   } while((epress=evalpress()) == 1);
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if(search())
					break;
				instr(24);
			       }
			      if(eraseline(eex,eey))
			       {
				 instr(0);
				 redraw(frame,ON);
				}
			       else
			       {
				 instr(10);
				 sleep(2);
				}
			     }
			 case GDEF:
				G_force = Gstore = 10;
				Gdisplay();
				return(1);
			 case FLSH:
				if(no_pictures())
					return(1);
				if(!flash)
				       {
					 if(!fptr->in_use)
					       {
						 instr(22);
						 sleep(2);
						 instr(0);
						 return(1);
						}
					 flash = frame;
					 gimlac(flash,UNFLASH+1);
					 return(1);
					}
				gimlac(flash,UNFLASH);
				flash = OFF;
				return(1);
			 case SAVE:
				if(dragflag || fileflag ||
				   no_pictures())
					return(1);
				gturn = proxon();
				fileflag = ON;
				do
				  {
				    instr(13);
				    while((press=gpenin(&x,&y)) != ESC);
				   } while((epress=evalpress()) == 1);
				fileflag = OFF;
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if(x<965 && y<1000)
				       {
					 if(!(fileflag=search(END)))
					       {
						 instr(3);
						 sleep(2);
						 instr(0);
						 if(gturn)
							proxoff();
						 return(6);
						}
					 frame = fileflag;
					 fptr = &frames[frame-1];
					}
				charter(OFF);
				if(gturn)
					proxoff();
				if(find_file(1))
				       {
					 if(fileflag)
						save(fileflag);
					   else
						for(ey=2;ey<FRAMES;ey++)
						       save(ey);
					 fflush(&buffer);
					 if(close(buffer.fildes) < 0)
					       {
						 print("file close fail\n");
						 close(buffer.fildes);
						}
					}
				uncharter();
				instr(0);
				fileflag = OFF;
				return(6);
			 case REST:
				if(dragflag || fileflag)
					return(1);
				charter(OFF);
				ey = find_file(0);
				uncharter();
				if(ey)
				       {
					 instr(23);
					 restore();
					}
				instr(0);
				return(6);
			 case TEXT:
				if(dragflag)
					return(1);
				instr(15);
				charter(OFF);
				esptr = estring;
				for(ey=0 ; (echar=getchar()) != NL && ey<CHARS ; ey++)
					*esptr++ = echar;
				if(esptr == estring)
				       {
					 uncharter();
					 instr(0);
					 return(1);
					}
				*esptr = 0;
				if(ey >= CHARS && echar != NL)
					while((echar=getchar()) != NL);
				uncharter();
				gimlac(TEXTFRAME,OPEN);
				gtext(estring);
				gclose();
				gdrag(TEXTFRAME);
				dragflag = TEXTFRAME;
				do
				   {
				     instr(14);
				     while((press=gpenin(&x,&y)) != ESC);
				    } while((epress=evalpress()) == 1);
				if(epress == 4)
				       {
					 search(END);
					 if(y > 1023-11)
						y = 1023-11;
					 if(y < 5)
						y = 5;
					 eex = ey*CHARWIDTH;
					 eey = 1023-eex;
					 if(x > eey)
						x = eey;
					 gdrag(0);
					 greposition(TEXTFRAME,x,y);
					 if(addtext(estring,x,y,eex,ey));
						redraw(frame,ON);
					 instr(0);
					 gimlac(TEXTFRAME,DELETE);
					 dragflag = OFF;
					 return(6);
					}
				 instr(0);
				 gimlac(TEXTFRAME,DELETE);
				 dragflag = OFF;
				 return(epress);
			 case MERGE:
				if(dragflag || no_pictures())
					return(1);
				gturn = proxon();
				do
				   {
				     instr(16);
				     while((press=gpenin(&x,&y)) != ESC);
				    } while((epress=evalpress()) == 1 || epress == 7);
				instr(0);
				if(epress != 4)
				       {
					 if(gturn)
						proxoff();
					 return(epress);
					}
				if(x<965 && y<1000)
				       {
					 if(!(ey=search(END)))
					       {
						 instr(3);
						 sleep(2);
						 instr(0);
						 if(gturn)
							proxoff();
						 return(1);
						}
					 if(ey != frame)
					       {
						 merge(ey);
						 redraw(frame,ON);
						}
					}

				   else
				       {
					 for(ey=3 ; ey<FRAMES ; ey++)
						if(ey != frame && !merge(ey))
							break;
					 redraw(frame,ON);
					}
				if(gturn)
					proxoff();
				return(7);
			}
		}
	 return(4);
	}

/* This routine deals with the first level of screen presses,line
   drawing and moving pictures around the screen.It maintains the
   continuity of the vector storage and deals with the difference
   between the returns from evalpress().
*/

command()
       {
	 register cpress,cframe;
	 register struct vectordef *cvptr;
	 while((press=gpenin(&x,&y)) != ESC);
	 cpress=evalpress();
	 if(cpress == 2)
	       {
		 for(;;)
		       {
			 if(!continuous || firstime)
			       {
				 do
				   {
				     instr(1);
				     while((press = gpenin(&x,&y)) != ESC);
				    } while((cpress=evalpress()) < 4);
				 if(cpress >= 6)
					return(1);
				 search(END);
				 firstime = 0;
				}
			 gimlac(frame,OPEN);
			 if(y > 1011)
				y = 1011;
			 else if(y < 5)
				y = 5;
			 gpointo(x,y);
			 gclose();
			 pre_x = x-fptr->xdif;
			 pre_y = y-fptr->ydif;
			 cframe = frame;
			 do
			   {
			     instr(2);
			     while((press = gpenin(&x,&y)) != ESC);
			    } while((cpress=evalpress()) == 1 );
			 if(cpress == 2)
			       {
				 redraw(frame,ON);
				 continue;
				}
			 if(cpress != 4)
			       {
				 if(!frames[cframe-1].in_use)
					gimlac(cframe,DELETE);
				   else
					redraw(cframe,ON);
				 return(1);
				}
			 if(y > 1011)
				y = 1011;
			 else if(y < 5)
				y = 5;
			 if(!fptr->in_use)
			       {
				 if((fptr->in_use = -getvec()) > 0)
				       {
					 instr(0);
					 fptr->in_use = 0;
					 return(1);
					}
				 pics =+ 1;
				 fptr->xpos = pre_x;
				 fptr->ypos = pre_y;
				 fptr->xdif = fptr->ydif = 0;
				 fptr->lastvec = cvptr = vptr;
				 search(END);
				 cvptr->mode = (dots ? DOTS : LINE);
				 cvptr->x_pos = x;
				 cvptr->y_pos = y;
				 cvptr->prevec = -frame;
				 cvptr->nextvec = -frame;
				}
			    else
			       {
				 cvptr = fptr->lastvec;
				 if((cvptr->nextvec=getvec()) < 0)
				       {
					 instr(0);
					 redraw(frame,ON);
					 return(1);
					}
				 vptr->mode = MOVE;
				 vptr->x_pos = pre_x;
				 vptr->y_pos = pre_y;
				 vptr->prevec = cvptr;
				 cvptr = vptr;
				 search(END);
				 if((cvptr->nextvec=getvec()) < 0)
				       {
					 instr(0);
					 if(cvptr->prevec < 0)
					       {
						 delete(frame);
						 return(1);
						}
					 vptr->mode = cvptr->mode = 0;
					 vptr->x_pos = vptr->y_pos = 0;
					 cvptr->x_pos = cvptr->y_pos = 0;
					 fptr->lastvec = cvptr->prevec;
					 vptr->prevec = cvptr->prevec = -1;
					 vptr->nextvec = avail;
					 avail = cvptr;
					 cvptr = fptr->lastvec;
					 cvptr->nextvec = -frame;
					 redraw(frame,ON);
					 return(1);
					}
				 vptr->mode = (dots ? DOTS : LINE);
				 vptr->x_pos = x-fptr->xdif;
				 vptr->y_pos = y-fptr->ydif;
				 vptr->prevec = cvptr;
				 vptr->nextvec = -frame;
				 fptr->lastvec = vptr;
				 if(fptr->in_use>0)
					fptr->in_use = -fptr->in_use;
				}
			 gimlac(frame,OPEN);
			 dots ? gdotsto(x,y) : glineto(x,y);
			 gclose();
			}
		}
	 if(cpress != 4 || no_pictures())
		return(1);
	 if(cframe=search(END))
	       {
		 if(flash)
		       {
			 gimlac(flash,UNFLASH);
			 flash = cframe;
			 gimlac(flash,FLASH);
			}
		 frame = cframe;
		 fptr = &frames[frame-1];
		 if(fptr->in_use<0)
			redraw(frame,ON);
		 gdrag(frame);
		 dragflag = frame;
		 do
		   {
		     instr(4);
		     while((press=gpenin(&x,&y)) != ESC);
		    } while((cpress = evalpress()) < 4);
		 dragflag = OFF;
		 gdrag(0);
		 instr(0);
		 if(cpress == 5)
			return(1);
		 if(cpress == 6)
		       {
			 x=fptr->xpos+fptr->xdif;
			 y=fptr->ypos+fptr->ydif;
			}
		   else
			 search(frame);
		 reposition();
		 return(1);
		}
	 instr(3);
	 sleep(2);
	 instr(0);
	 return(1);
	}

/* This routine makes sure the menus are on the screen after they 
   have been moved.
*/

reposmenu()
       {
	 register width,height,no_of_chars;
	 no_of_chars = (Gdisp ? 21 : 12);
	 width = 1023-no_of_chars*CHARWIDTH;
	 height= MENULENGTH*CHARHEIGHT+TITLEWIDTH;
	 if(x<25)
		x = 25;
	 else if(x>width)
		x = width;
	 if(y>995)
		y = 995;
	 else if(y<height)
		y = height;
	 greposition(MENU,x,y);
	 if(Gdisp)
		greposition(GFRAME,x,y);
	 instr(0);
	 frames[0].xpos = x;
	 frames[0].ypos = y;
	}

/* This routine gets the next available vector structure from
   the chain of available ones. If it succeeds it returns the
   address of this structure as well as putting its value in vptr
   (a global vector pointer).If it fails it outputs a message to this
   effect & returns minus the frame number(this is specifically
   to maintain the continuity of the vector storage chain).
*/

getvec()
       {
	 if(avail->nextvec == END)
	       {
		 print("no more vector space\n");
		 sleep(2);
		 return(-frame);
		}
	 vptr = avail;
	 avail = vptr->nextvec;
	 return(vptr);
	}

/* This routine tries to match the current  position with any point
   within the range of the variable G_force.If it cannot do this it
   tries to match it with any line perpendicular to the axis
   eminating from such points.If it succeeds on any one of these the
   current position stored in global variables x & y are altered. If
   it succeeds in the point match , the frame number of the point is
   returned.Otherwise 0 is returned. The frame number passed through
   skip will not be tested.
*/

search(skip)
       {
	 register i;
	 int sxmin,symin,sxmax,symax,xmin,xmax,ymin,ymax;
	 int nx,ny,xtmp,ytmp,linx,liny;
	 char total,pointhit;
	 register struct framesdef *sfptr;
	 register struct vectordef *svptr;
	 if((xmin = x-G_force) < 0)
		xmin = 0;
	 if((ymin = y-G_force) < 0)
		ymin = 0;
	 xmax = x+G_force;
	 ymax = y+G_force;
	 total = pointhit = 0;
	 linx = liny = 2000;
	 for(i=3,sfptr = &frames[2] ; i<FRAMES ; i++,sfptr++)
	       {
		 if(!sfptr->in_use || skip == i)
			continue;
		 sxmin = xmin-sfptr->xdif;
		 sxmax = xmax-sfptr->xdif;
		 symin = ymin-sfptr->ydif;
		 symax = ymax-sfptr->ydif;
		 if(sfptr->xpos >= sxmin && sfptr->xpos <= sxmax)
		       {
			 total++;
			 xtmp = x-(sfptr->xpos+sfptr->xdif);
			 if(mod(linx) > mod(xtmp))
				linx = xtmp;
			}
		 if(sfptr->ypos >= symin && sfptr->ypos <= symax)
		       {
			 total++;
			 ytmp = y-(sfptr->ypos+sfptr->ydif);
			 if(mod(liny) > mod(ytmp))
				liny = ytmp;
			}
		 if(total == 2 && mod(nx)+mod(ny) > mod(xtmp)+mod(ytmp))
		       {
			 nx = xtmp;
			 ny = ytmp;
			 pointhit = i;
			}
		 total = 0;
		 for(svptr = mod(sfptr->in_use) ;; svptr = svptr->nextvec)
		   {
		     if(!svptr->mode)
			break;
		     if(svptr->mode == CHAR)
			continue;
		     if(svptr->x_pos >= sxmin && svptr->x_pos <= sxmax)
		       {
			 total++;
			 xtmp = x-(svptr->x_pos+sfptr->xdif);
			 if(mod(linx) > mod(xtmp))
				linx = xtmp;
			}
		     if(svptr->y_pos >= symin && svptr->y_pos <= symax)
		       {
			 total++;
			 ytmp = y-(svptr->y_pos+sfptr->ydif);
			 if(mod(liny) > mod(ytmp))
				liny = ytmp;
			}
		     if(total == 2 && mod(nx)+mod(ny) > mod(xtmp)+mod(ytmp))
		       {
			 nx = xtmp;
			 ny = ytmp;
			 pointhit = i;
			}
		     total = 0;
		     if(svptr->nextvec < 0)
			break;
		    }
		}
	 if(pointhit)
	       {
		 x =- nx;
		 y =- ny;
		 return(pointhit);
		}
	 if(linx != 2000)
		x =- linx;
	 if(liny != 2000)
		y =- liny;
	 return(0);
	}

/* This routine redraws the frame in rframe.If rvis = 0 it does
   this invisibly. It redraws the frame as if it was created at
   its current position & resets xdif & ydif accordingly.
*/

redraw(rframe,rvis)
       {
	 register char *chptr;
	 register struct vectordef *rvptr;
	 register struct framesdef *rfptr;
	 int i;
	 char rstring[5],*rsptr;
	 rfptr = &frames[rframe-1];
	 if(!rfptr->in_use)
		return;
	 rfptr->xpos =+ rfptr->xdif;
	 rfptr->ypos =+ rfptr->ydif;
	 gimlac(rframe,REPLACE);
	 gmoveto(rfptr->xpos,rfptr->ypos);
	 if(rvis == OFF)
	       {
		 gclose();
		 gimlac(rframe,INVISIBLE);
		 gimlac(rframe,OPEN);
		}
	 if(rfptr->in_use < 0)
		rfptr->in_use = -rfptr->in_use;
	 for(rvptr = rfptr->in_use ;; rvptr = rvptr->nextvec)
	   {
	     switch(rvptr->mode)
	       {
		 case MOVE:
			rvptr->x_pos =+ rfptr->xdif;
			rvptr->y_pos =+ rfptr->ydif;
			gmoveto(rvptr->x_pos,rvptr->y_pos);
			break;
		 case LINE:
			rvptr->x_pos =+ rfptr->xdif;
			rvptr->y_pos =+ rfptr->ydif;
			glineto(rvptr->x_pos,rvptr->y_pos);
			break;
		 case DOTS:
			rvptr->x_pos =+ rfptr->xdif;
			rvptr->y_pos =+ rfptr->ydif;
			gdotsto(rvptr->x_pos,rvptr->y_pos);
			break;
		 case CHAR:
			chptr = &rvptr->x_pos;
			for(rsptr=rstring,i=0 ; i<4 ; i++)
				*rsptr++ = *chptr++;
			*rsptr = 0;
			gtext(rstring);
			break;
		 default:
			gclose();
			print("picture data error\n");
			gimlac(rframe,OPEN);
		}
	     if(rvptr->nextvec < 0)
		break;
	    }
	 gclose();
	 gimlac(rframe,VISIBLE);
	 rfptr->xdif = rfptr->ydif = 0;
	 if(flash)
	       {
		 if(flash != frame)
		       {
			 gimlac(flash,UNFLASH);
			 flash = frame;
			}
		 gimlac(flash,UNFLASH+1);
		}
	}

/* This routine returns the vector structures  attatched to dframe
   to the available chain,zeroises its frame structure and deletes
   the corresponding picture from the screen. It also makes dframe
   the current frame and turns flash off since a deleted frame can
   not flash.
*/

delete(dframe)
       {
	 register struct vectordef *dvptr,*ddvptr;
	 register struct framesdef *dfptr;
	 dfptr = &frames[dframe-1];
	 dvptr = (dfptr->in_use>0 ? dfptr->in_use : -dfptr->in_use);
	 gimlac(dframe,DELETE);
	 dfptr->in_use = 0;
	 dfptr->xpos = dfptr->ypos = 0;
	 dfptr->xdif = dfptr->ydif = 0;
	 dfptr->lastvec = 0;
	 for(ddvptr = dvptr ;; ddvptr = ddvptr->nextvec)
	       {
		 ddvptr->mode = 0;
		 ddvptr->x_pos = ddvptr->y_pos = 0;
		 ddvptr->prevec = -1;
		 if(ddvptr->nextvec < 0)
			break;
		}
	 ddvptr->nextvec = avail;
	 avail = dvptr;
	 if(flash)
	       {
		 gimlac(flash,UNFLASH);
		 flash = OFF;
		}
	 pics =- 1;
	}

/* This routine is called after any picture frame has been moved
   and it makes sure the picture is replaced fully on the screen
   it leaves a small margin top & bottom (for characters such as
   b,d,y & j).
*/

reposition()
       {
	 register struct vectordef *rvptr;
	 register struct framesdef *rfptr;
	 register rxpos;
	 int xover,yover,rxover,ryover,rypos;
	 xover = yover = 0;
	 rfptr = fptr;
	 if(y>1023-12)
		y = 1023-12;
	 else if(y<5)
		y = 5;
	 for(rvptr = rfptr->in_use ;; rvptr = rvptr->nextvec)
	   {
	     while(rvptr->mode == CHAR)
			rvptr = rvptr->nextvec;
	     rxpos = rvptr->x_pos+x-rfptr->xpos;
	     rypos = rvptr->y_pos+y-rfptr->ypos;
	     if(rxpos>1023 && (rxover=rxpos-1023) > mod(xover))
			xover = rxover;
	     if(rxpos < 0 && rxpos < -mod(xover))
			xover = rxpos;
	     if(rypos>1023-12 && (ryover=rypos-1023+12) > mod(yover))
			yover = ryover;
	     if(rypos<5 && (ryover=rypos-5) < -mod(yover))
			yover = ryover;
	     if(rvptr->nextvec < 0)
		break;
	    }
	 x =- xover;
	 y =- yover;
	 greposition(frame,x,y);
	 rfptr->xdif = x-rfptr->xpos;
	 rfptr->ydif = y-rfptr->ypos;
	}

/* I bet you can't guess what this routine does.
*/

mod(number)
       {
	 return(number<0 ? -number : number);
	}

/* This routine searches for 2 consecutive points within G_force
   of the 2 points (ex,ey) & (x,y) passed from evalpress().Chars
   are skipped over and are thus treated as a line (according to
   the "movetos" surrounding them. If such points are found 1 is
   returned, after control is passed to remove(), otherwise 0 is
   returned.
*/

eraseline(ex,ey)
       {
	 int dx,dy,dex,dey,i;
	 register struct framesdef *efptr;
	 register struct vectordef *evptr,*eevptr;
	 for(i=3,efptr = &frames[2] ; i<FRAMES ; i++,efptr++)
	       {
		 if(!efptr->in_use)
			continue;
		 dx = x-efptr->xdif;
		 dy = y-efptr->ydif;
		 dex = ex-efptr->xdif;
		 dey = ey-efptr->ydif;
		 eevptr=(efptr->in_use<0 ? -efptr->in_use:efptr->in_use);
		 while(eevptr->mode == CHAR)
			eevptr = eevptr->nextvec;
		 if(efptr->xpos == dx && efptr->ypos == dy &&
		    eevptr->x_pos == dex && eevptr->y_pos == dey)
		       {
			 frame = i;
			 fptr = efptr;
			 vptr = eevptr;
			 remove(1);
			 return(1);
			}
		 if(efptr->xpos == dex && efptr->ypos == dey &&
		    eevptr->x_pos == dx && eevptr->y_pos == dy)
		       {
			 frame = i;
			 fptr = efptr;
			 vptr = eevptr;
			 remove(1);
			 return(1);
			}
		 for(;;)
		       {
			 if(eevptr->nextvec < 0)
				break;
			 eevptr = eevptr->nextvec;
			 if(eevptr->x_pos == dx && eevptr->y_pos == dy)
			       {
				 evptr=eevptr->nextvec;
				 while(evptr->mode == CHAR)
					evptr = evptr->nextvec;
				 if(evptr->x_pos == dex && evptr->y_pos == dey)
				       {
					 frame = i;
					 fptr = efptr;
					 vptr = eevptr;
					 remove(0);
					 return(1);
					}
				}
			 if(eevptr->x_pos == dex && eevptr->y_pos == dey)
			       {
				 evptr=eevptr->nextvec;
				 while(evptr->mode == CHAR)
					evptr = evptr->nextvec;
				 if(evptr->x_pos == dx && evptr->y_pos == dy)
				       {
					 frame = i;
					 fptr = efptr;
					 vptr = eevptr;
					 remove(0);
					 return(1);
					}
				}
			 do
			   {
			     eevptr = eevptr->nextvec;
			    } while(eevptr->mode == CHAR);
			}
		}
	 return(0);
	}

/* This routine does the donkey work of returning the relevant
   structures to the available chain or deleting the frame
   complely.If state does not equal zero,the point of origin
   of the frame must be altered.
*/

remove(state)
       {
	 register struct vectordef *rvptr,*rrvptr,*rrrvptr;
	 if(state)
	       {
		 for(rrvptr=vptr ; rrvptr->mode == CHAR ; rrvptr = rrvptr->nextvec)
		       {
			 rrvptr->mode = 0;
			 rrvptr->prevec = -1;
			 rrvptr->x_pos = rrvptr->y_pos = 0;
			}
		 if(rrvptr->nextvec < 0)
		       {
			 delete(frame);
			 return;
			}
		 rrvptr->mode = 0;
		 rrvptr->prevec = -1;
		 rrvptr->x_pos = rrvptr->y_pos = 0;
		 rrvptr = rrvptr->nextvec;
		 fptr->xpos = rrvptr->x_pos;
		 fptr->ypos = rrvptr->y_pos;
		 rrvptr->mode = 0;
		 rrvptr->x_pos = rrvptr->y_pos = 0;
		 rrrvptr = rrvptr->nextvec;
		 rrrvptr->prevec= -frame;
		 rrvptr->prevec = -1;
		 fptr->in_use = -rrrvptr;
		 rrvptr->nextvec = avail;
		 avail = vptr;
		 return;
		}
	 rrvptr = vptr;
	 rvptr = rrvptr->prevec;
	 rrvptr->prevec = -1;
	 rrvptr->x_pos = rrvptr->y_pos = 0;
	 do
	   {
	     rrvptr->mode = 0;
	     rrvptr = rrvptr->nextvec;
	     rrvptr->prevec = -1;
	     rrvptr->x_pos = rrvptr->y_pos = 0;
	    } while(rrvptr->mode == CHAR);
	 rrvptr->mode = 0;
	 if(rvptr > MAXNO)
	       {
		 if(rrvptr->nextvec < 0)
		       {
			 delete(frame);
			 return;
			}
		 fptr->in_use = -rrvptr->nextvec;
		}
	    else
		rvptr->nextvec = rrvptr->nextvec;
	 if(rrvptr->nextvec < 0)
	       {
		 rvptr->nextvec = -frame;
		 fptr->lastvec = rvptr;
		}
	   else
	       {
		 rrrvptr = rrvptr->nextvec;
		 rrrvptr->prevec = rvptr;
		}
	 rrvptr->nextvec = avail;
	 avail = vptr;
	}

/* As might be expected this routine is responsible for copying
   the vector chain of one frame into another.Returns 0 if fail
   1 if success.
*/
copy()
       {
	 int cframe;
	 register struct framesdef *cfptr;
	 register struct vectordef *cvptr,*ccvptr;
	 struct vectordef *cvstore;
	 if((cframe = next_frame(ON)) < 0)
		return(0);
	 cfptr = &frames[cframe-1];
	 ccvptr = cfptr->in_use = getvec();
	 if(cfptr->in_use < 0)
	       {
		 cfptr->in_use = 0;
		 return(0);
		}
	 pics =+ 1;
	 cfptr->in_use = -cfptr->in_use;
	 cfptr->xpos = fptr->xpos;
	 cfptr->ypos = fptr->ypos;
	 cfptr->xdif = fptr->xdif;
	 cfptr->ydif = fptr->ydif;
	 cvptr = (fptr->in_use < 0 ? -fptr->in_use:fptr->in_use);
	 ccvptr->mode = cvptr->mode;
	 ccvptr->x_pos = cvptr->x_pos;
	 ccvptr->y_pos = cvptr->y_pos;
	 ccvptr->prevec = -cframe;
	 if(cvptr->nextvec < 0)
	       {
		 ccvptr->nextvec = -cframe;
		 cfptr->lastvec = ccvptr;
		 frame = cframe;
		 fptr = cfptr;
		 return(1);
		}
	 for(;;)
	       {
		 cvstore = ccvptr;
		 ccvptr = cvstore->nextvec = getvec();
		 if(cvstore->nextvec < 0)
		       {
			 delete(cframe);
			 return(0);
			}
		 cvptr = cvptr->nextvec;
		 ccvptr->mode = cvptr->mode;
		 ccvptr->x_pos = cvptr->x_pos;
		 ccvptr->y_pos = cvptr->y_pos;
		 ccvptr->prevec = cvstore;
		 if(cvptr->nextvec < 0)
			break;
		}
	 ccvptr->nextvec = -frame;
	 cfptr->lastvec = ccvptr;
	 frame = cframe;
	 fptr = cfptr;
	 return(1);
	}

/* This routine saves vector structure of sframe in the file
   previously opened by find_file.It is stored as a multiple
   of 3 word fields preceeded by a ".p"(put in by find_file)
   the fields are:
	mode...takes same values as mode in vector structure
	xpos...  "    "      "   "  x_pos "   "       "   "
	ypos...you'll never guess this one.
   Each frame is terminated by a -100 (END).
*/

save(sframe)
       {
	 register struct framesdef *sfptr;
	 register struct vectordef *svptr;
	 sfptr = &frames[sframe-1];
	 if(!sfptr->in_use)
		return;
	 putw(sfptr->xpos+sfptr->xdif,&buffer);
	 putw(sfptr->ypos+sfptr->ydif,&buffer);
	 for(svptr = mod(sfptr->in_use) ;; svptr = svptr->nextvec)
	       {
		 putw(svptr->mode,&buffer);
		 if(svptr->mode != CHAR)
		       {
			 putw(svptr->x_pos+sfptr->xdif,&buffer);
			 putw(svptr->y_pos+sfptr->ydif,&buffer);
			}
		   else
		       {
			 putw(svptr->x_pos,&buffer);
			 putw(svptr->y_pos,&buffer);
			}
		 if(svptr->nextvec < 0)
			break;
		}
	 putw(END,&buffer);
	}

/* This routine opens or creates a file, according to fcreate
   (if 1 it will create file and put ".p" in the first 2 char
   positions).If the first character in the filename is a '?'
   the routine will execute a "/bin/fi" on the pathname which
   follows,which if blank is taken to be "/etc/piclib".If the
   first char in the filename is a '*' then the filename that
   follows is appended to "/etc/piclib/".
*/

find_file(fcreate)
       {
	 register i;
	 register char fchar,*fsptr;
	 int pid,fpid,frtcd;
	 char tmpstr[CHARS+1],*tmptr;
	 for(;;)
	       {
		 instr(12);
		 fsptr = fstring;
		 for(i=0 ; (fchar=getchar()) != NL ; i++)
			if(fchar == '\t')
				i =+ 7;
			   else if(fchar != ' ')
				break;
		 for( ; fchar != NL && i<CHARS ; i++,fchar=getchar())
			 *fsptr++ = fchar;
		 if(i >= CHARS)
			while(getchar() != NL);
		 if(fsptr == fstring)
			return(0);
		 *fsptr = 0;
		 fsptr = fstring;
		 if(*fsptr == '?')
		       {
			 if(!*(fsptr+1))
				fsptr = "/etc/piclib";
			   else
				fsptr = fsptr+1;
			 if((pid = fork()) == 0)
			       {
				 execl("/bin/fi","fi",fsptr,0);
				 print("cannot execute search\n");
				}
			 signal(2,1);
			 while((fpid=wait(&frtcd)) != pid && fpid != -1);
			 signal(2,reseter);
			 continue;
			}
		 if(*fsptr == '*')
		       {
			 tmptr = tmpstr;
			 fsptr++;
			 do
			   {
			     *tmptr++ = *fsptr;
			    } while(*fsptr++);
			 tmptr = "/etc/piclib/";
			 fsptr = fstring;
			 while(*tmptr)
				*fsptr++ = *tmptr++;
			 tmptr = tmpstr;
			 do
			   {
			     *fsptr++ = *tmptr;
			     } while(*tmptr++);
			}
		 if(fopen(fstring,&buffer) == 0 && !fcreate)
			return(1);
		 if(fcreate && fcreat(fstring,&buffer) > 0)
		       {
			 putc('.',&buffer);
			 putc('p',&buffer);
			 return(1);
			}
		 print(fstring);
		 print(" cannot open\n");
		}
	}

/* This routine tests if the currently open file contains a
   picture and,if so,restors it to its former glory (on the
   screen).
*/

restore()
       {
	 register temp;
	 register struct vectordef *rvptr,*rrvptr;
	 if(getc(&buffer) != '.' || getc(&buffer) != 'p')
	       {
		 print(fstring);
		 print(" is not a picture\n");
		 sleep(2);
		 return;
		}
	 for(temp = getw(&buffer) ;;)
	       {
		 if(next_frame(OFF) < 0)
			return;
		 if((fptr->in_use = -getvec()) > 0)
		       {
			 fptr->in_use = 0;
			 return;
			}
		 pics =+ 1;
		 rrvptr = vptr;
		 fptr->xpos = temp;
		 fptr->ypos = getw(&buffer);
		 fptr->xdif = fptr->ydif = 0;
		 rrvptr->mode = getw(&buffer);
		 rrvptr->x_pos = getw(&buffer);
		 rrvptr->y_pos = getw(&buffer);
		 rrvptr->prevec = -frame;
		 for(temp=getw(&buffer) ; temp >= 0 ; temp=getw(&buffer))
		       {
			 rvptr = rrvptr;
			 rrvptr = rvptr->nextvec = getvec();
			 if(rvptr->nextvec < 0)
			       {
				 delete(frame);
				 return;
				}
			 rrvptr->mode = temp;
			 rrvptr->x_pos = getw(&buffer);
			 rrvptr->y_pos = getw(&buffer);
			 rrvptr->prevec = rvptr;
			}
		 rrvptr->nextvec = -frame;
		 fptr->lastvec = rrvptr;
		 redraw(frame,ON);
		 if((temp = getw(&buffer)) == -1)
		       {
			 if(close(buffer.fildes) < 0)
			       {
				 print("file close fail\n");
				 close(buffer.fildes);
				}
			 return;
			}
		}
	}

/* This routine inserts the string, pointed to by astring,in
   the vector chain of the current frame in position (ax,ay)
   arhx contains the previously calculated  string width and
   acount contains a character count.  Returns 1 if success.
*/

addtext(astring,ax,ay,arhx,acount)
       char *astring;
       {
	 int i,j;
	 register char *asptr,*aasptr;
	 register struct vectordef *avptr;
	 if(!fptr->in_use)
	       {
		 if((fptr->in_use = -getvec()) > 0)
		       {
			 fptr->in_use = 0;
			 return(0);
			}
		 pics =+ 1;
		 fptr->xpos = ax;
		 fptr->ypos = ay;
		 fptr->xdif = fptr->ydif = 0;
		 fptr->lastvec = avptr = vptr;
		 avptr->prevec = -frame;
		}
	   else
	       {
		 avptr = fptr->lastvec;
		 if((avptr->nextvec = getvec()) < 0)
			return(0);
		 vptr->prevec = avptr;
		 avptr = vptr;
		 avptr->mode = MOVE;
		 avptr->x_pos = ax-fptr->xdif;
		 avptr->y_pos = ay-fptr->ydif;
		 if((avptr->nextvec = getvec()) < 0)
		       {
			 avptr->mode = 0;
			 avptr->x_pos = avptr->y_pos = 0;
			 vptr = avptr->prevec;
			 vptr->nextvec = -frame;
			 avptr->prevec = -1;
			 avptr->nextvec = avail;
			 avail = avptr;
			 return(0);
			}
		 vptr->prevec = avptr;
		 avptr = vptr;
		}
	 for(asptr = astring,i=0 ; i<acount ; i =+ 4)
	       {
		 avptr->mode = CHAR;
		 for(aasptr = &avptr->x_pos,j=0 ; j<4 ; j++)
			*aasptr++ = *asptr++;
		 if((avptr->nextvec = getvec()) < 0)
		       {
			 delchars();
			 return(0);
			}
		 vptr->prevec = avptr;
		 avptr = vptr;
		}
	 avptr->mode = MOVE;
	 avptr->x_pos = arhx+x-fptr->xdif;
	 avptr->y_pos = ay-fptr->ydif;
	 avptr->nextvec = -frame;
	 fptr->lastvec = avptr;
	 return(1);
	}

/* This routine returns the vector nodes used up in a failed
   addtext().
*/

delchars()
       {
	 register struct vectordef *dvptr,*ddvptr;
	 for(dvptr=vptr->prevec ; dvptr->mode == CHAR ; dvptr = dvptr->prevec);
	 ddvptr = dvptr->prevec;
	 if(ddvptr->prevec < 0)
	       {
		 delete(frame);
		 return;
		}
	 ddvptr->nextvec = -frame;
	 for(ddvptr = dvptr ;; dvptr = dvptr->nextvec)
	       {
		 dvptr->mode = 0;
		 dvptr->x_pos = dvptr->y_pos = 0;
		 dvptr->prevec = -1;
		 if(dvptr->nextvec < 0)
			break;
		}
	 dvptr->nextvec = avail;
	 avail = ddvptr;
	}

/* This routine merges mframe into the current frame.If frame
   is not in use mframe becomes the current frame & if mframe
   is not in use the routine returns.This routine returns a 1
   unless it runs out of vector structures,when it returns 0.
*/

merge(mframe)
       {
	 int mxdif,mydif;
	 register struct framesdef *mfptr;
	 register struct vectordef *mvptr,*mmvptr;
	 if(!fptr->in_use)
	       {
		 frame = mframe;
		 fptr = &frames[frame-1];
		 return(1);
		}
	 mfptr = &frames[mframe-1];
	 if(!mfptr->in_use)
		return(1);
	 if((mvptr=getvec()) > MAXNO)
		return(0);
	 mxdif = mfptr->xdif-fptr->xdif;
	 mydif = mfptr->ydif-fptr->ydif;
	 mmvptr = fptr->lastvec;
	 mmvptr->nextvec = mvptr;
	 mvptr->mode = MOVE;
	 mvptr->x_pos = mfptr->xpos+mxdif;
	 mvptr->y_pos = mfptr->ypos+mydif;
	 mvptr->nextvec = (mfptr->in_use<0 ? -mfptr->in_use:mfptr->in_use);
	 mvptr->prevec = mmvptr;
	 mmvptr = mvptr;
	 mvptr = mvptr->nextvec;
	 for(mvptr->prevec = mmvptr ;; mvptr = mvptr->nextvec)
	       {
		 if(mvptr->mode == CHAR)
			continue;
		 mvptr->x_pos =+ mxdif;
		 mvptr->y_pos =+ mydif;
		 if(mvptr->nextvec < 0)
			break;
		}
	 mfptr->in_use = 0;
	 mfptr->xpos = mfptr->ypos = 0;
	 mfptr->xdif = mfptr->ydif = 0;
	 mfptr->lastvec = 0;
	 fptr->lastvec = mvptr;
	 mvptr->nextvec = -frame;
	 gimlac(mframe,DELETE);
	 return(1);
	}

/* Routine to test if there are any pictures & output relevant
   message.
*/

no_pictures()
       {
	 if(!pics)
	       {
		 instr(21);
		 sleep(2);
		 instr(0);
		 return(1);
		}
	 return(0);
	}

/* Printf(%s) but faster and smaller
*/

print(str)
       char *str;
       {
	 register i;
	 register char *sptr;
	 for(i=0,sptr=str ; *sptr++ ; i++);
	 write(2,str,i);
	}

/* Routine to automatically turn on proximity
*/

proxon()
       {
	 if(G_force)
		return(0);
	 G_force = Gstore;
	 if(Gdisp)
		 Gdisplay();
	 return(1);
	}

/* Routine to counteract proxon()
*/

proxoff()
       {
	 G_force = OFF;
	 if(Gdisp)
		Gdisplay();
	}
