#
/*sends 8 formants,durn,CR or if silent CTRLZ */
/*main to read in output of speak i.e. phon durn CR
or    phon durn PFLAG pitch CR*/
#define	FLAG	07
#define	PFLAG	011
#define	CR	015
#define	CTRLZ	032	/*flag silent phoneme*/
#define	ASPMAX	63
#define	AFUNDMAX	63
#define	AHMAX	63
int prevphon	0;
int	prevdurn	5;
int	prevpitch	32;
char	prevflag	'o';
int	phon,durn,pitch;
char	flag;
char	form[]{ 64,63,58,44,95,95,95,64,37,CTRLZ};
struct phontab {
	int tabflag;
	int f[7];
};
struct phontab tab[]{
	'o',32,31,26,12,63,63,63,
	's',32,31,26,57,63,63,0,
	's',35,24,33,57,63,63,0,
	's',36,47,31,57,63,63,0,
	's',38,51,18,57,63,63,0,
	's',35,14,34,57,63,63,0,
	's',31,15,19,57,63,63,0,
	'l',35,38,46,57,63,63,0,
	'l',51,57,13,57,63,63,30,
	'l',30,28,32,57,63,63,0,
	'l',33,19,39,57,63,63,0,
	'l',36,8,24,57,63,63,0,
	'l',26,14,14,57,63,63,0,
	'g',0,22,9,57,63,63,0,
	'g',32,4,9,49,63,63,0,
	'g',48,22,19,44,63,63,0,
	'g',48,57,9,44,63,63,0,
	'n',27,6,6,63,63,63,0,
	'v',16,6,0,63,63,63,63,
	'u',16,6,0,63,32,34,63,
	'n',58,41,6,9,63,63,0,
	'v',58,41,0,9,63,63,63,
	'u',58,41,0,9,32,34,63,
	'n',32,58,6,60,63,63,0,
	'v',32,58,0,60,63,63,63,
	'u',32,58,0,63,32,34,63,
	'x',58,41,6,0,0,63,63,
	'x',58,41,6,0,40,63,0,
	'x',38,54,6,60,0,27,63,
	'x',38,54,6,60,0,15,63,
	'x',58,6,6,27,31,27,63,
	'x',58,6,6,2,20,63,18,
	'x',58,41,6,25,35,63,63,
	'x',58,41,6,25,35,63,19,
	'a',38,54,6,50,63,63,63,
	'a',38,52,6,59,34,63,4,
	'o',35,24,33,37,63,0,63,
};
int fildes	1;	/*for iota*/
main(){
char c,d;	/*read FLAG l*/
pitch=prevpitch;
while((c=getchar())!=FLAG);
while((c=getchar())!='l');
outp(1);
outp(2);	/*sends silent phoneme*/
while((c=getchar())!=FLAG){
	d=getchar();
	phon=c-32;
	durn=d-32;
	if((c=getchar())==PFLAG){
		pitch=getchar()-32;
		c=getchar()-32;
	}
	if(c!=CR)getchar();	/*got one line*/
printf("pitch %d\n",pitch);
	send();
}
phon=0;
durn=5;
send();	/*silence before end*/
outp(3);	/*sennd terminator*/
exit();
}	/*end of main*/
send(){
/*interpolates from 
previous phoneme,sends durn,0-6,pitch*/
int tt,i,ft,j;
struct phontab *pp,*pprev;
pprev= &tab[prevphon];
pp= &tab[phon];
flag=pp->tabflag;
tt=settrans();
if(!tt){ 
	tt=durn+2;
	durn=2;
	}
form[8]=34;	/*durn 2 on trans*/
form[9]=CR;
for(i=1;i<tt;i++){
	for(j=0;j<7;j++){
		ft=interp(pprev->f[j],pp->f[j],tt,i,j);
		form[j]=ft+32;	/*put in op buffer*/
	}
	if(pitch!=prevpitch)
		ft=interp(prevpitch,pitch,tt,i);
	else ft=pitch;

	form[7]=pitch+32;
	outp(2);	/*send this transition*/
}
form[9]=(phon?CR:CTRLZ);
form[8]=2*durn+32;
for(j=0;j<7;j++){
	form[j]=pp->f[j]+32;
}
form[7]=pitch+32;
outp(2);
prevphon=phon;
prevdurn=durn;
prevpitch=pitch;
prevflag=flag;
return;
}

settrans(){
int tt;
if(flag=='u' || flag=='v' || flag=='n') tt= 2;
else if(prevflag=='u' || prevflag=='v' || prevflag=='n') tt=4;
else if(flag=='g' || ( ( prevflag=='s' || prevflag=='l')
			&& (flag=='s' || flag=='l'))) tt=0;
/* outside we adjust tt=durn+2 ss=2*/
else tt=5;
return(tt);
}

aval[] { 0,8,11,11,	/*63 to 60*/
	12,12,13,14,15,15,16,16,17,17,	/*59 to 50*/
	18,19,19,20,20,21,21,22,22,23,	/*49 to 40*/
	23,24,24,24,25,25,26,26,26,28,	/*39 to 30*/
	27,27,28,28,28,29,29,29,30,30,	/*29 to 20*/
	31,31,31,32,33,33,34,35,36,36,/*19 to 10*/
	37,38,38,39,41,42,43,45,49,63	/*9 to 0 */
};

interp(f0,f1,tt,i,param){
int step,val,a0;
	if(param<4 || param==7){
		step=((f1-f0)*i)/tt;
		val=f0+step;
	}
	else {

		if(prevflag=='u'){
			if(param==4 && i<=3) val=AHMAX;
			else if (param==5 && i==1) val=ASPMAX;
			else if (param==6 && i!=1) val=AFUNDMAX;
		}
		else if (prevflag=='v' && param==6) val=AFUNDMAX;
		else if (prevflag=='g' && param==5 && step!=1) val=ASPMAX;
		
		else {
			a0=aind(f0);

			step=(( aind(f1)-a0)*i)/tt;
			val=aval[a0+step];
		}
	}
return(val);
}

aind(f)
{
	int i;
	for(i=1;i<=63;i++)
		if(aval[i]>f) break;
	return(i);
}
outp(i){
char c;
switch(i){
	case 1: c=FLAG;
		write(fildes,&c,1);write(fildes,"l",1);
		break;
	case 2: write(fildes,form,10);
		break;
	case 3: c=FLAG;
		write(fildes,&c,1);
		break;
}
}
